fibonacciCache = {} # Tworzenie globalnej pamięci podręcznej

def fibonacci(nthNumber, indent=0):
    global fibonacciCache
    indentation = '.' * indent
    print(indentation + 'Wywołano funkcję fibonacci(%s).' % (nthNumber))

    if nthNumber in fibonacciCache:
        # Jeśli wartość jest już zapisana w pamięci podręcznej, to ją po prostu zwracamy
        print(indentation + 'Zwracam wartość z pamięci podręcznej: %s' % (fibonacciCache[nthNumber]))
        return fibonacciCache[nthNumber]

    if nthNumber == 1 or nthNumber == 2:
        # PRZYPADEK BAZOWY
        print(indentation + 'Przypadek bazowy fibonacci(%s). Funkcja zwraca 1.' % (nthNumber))
        fibonacciCache[nthNumber] = 1 # Aktualizacja pamięci podręcznej
        return 1
    else:
        # PRZYPADEK REKURENCYJNY
        print(indentation + 'Wywołuję fibonacci(%s) (nthNumber - 1).' % (nthNumber - 1))
        result = fibonacci(nthNumber - 1, indent=indent + 1)

        print(indentation + 'Wywołuję fibonacci(%s) (nthNumber - 2).' % (nthNumber - 2))
        result = result + fibonacci(nthNumber - 2, indent=indent + 1)

        print('Wywołanie fibonacci(%s) zwraca wartość %s.' % (nthNumber, result))
        fibonacciCache[nthNumber] = result # Aktualizacja pamięci podręcznej
        return result

print(fibonacci(10))
print(fibonacci(10))
